package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Obtention des informations sur la carte
 *
 */
public class InfoToken{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(InfoToken.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSlotToken Identifiant du slot hbergeant le token
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSlotToken) throws ExceptionTraitement {


		try {
		
			if(librairie != null) {
		
				ResultatInfo resultat = new ResultatInfo("Obtenir des informations sur la carte ");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
		
				// Rcupration des informations sur le token
				try {
					
					if(resultat != null) {
						
						// Traitement  tester
						CK_TOKEN_INFO info = librairie.C_GetTokenInfo(idSlotToken);
			
						if(info != null) {
			
							resultat.appendTraitement(new String(info.label).trim()+" (C_GetTokenInfo)");
							infos.put("Libell application attribu lors de l'initialisation de la carte",new String(info.label).trim());
							infos.put("Identifiant du fabricant de la carte",new String(info.manufacturerID));
							infos.put("Modle de la carte",new String(info.model));
							infos.put("Numro de srie de la carte",new String(info.serialNumber));
							infos.put("Nombre maximum de sessions pouvant tre ouvertes simultanment par une mme application sur la carte",Long.toString(info.ulMaxSessionCount));
							infos.put("Nombre de sessions que l'application courante a d'ouvertes sur la carte",Long.toString(info.ulSessionCount));
							infos.put("Nombre maximum de sessions en lecture/criture pouvant tre ouvertes simultanment par une mme application sur la carte",Long.toString(info.ulMaxRwSessionCount));
							infos.put("Nombre de sessions en lecture/criture que l'application courante a d'ouvertes sur la carte",Long.toString(info.ulRwSessionCount));
							infos.put("Longueur maximale (en octets) du code porteur",Long.toString(info.ulMaxPinLen));
							infos.put("Longueur minimale (en octets) du code porteur",Long.toString(info.ulMinPinLen));
							infos.put("Capacit mmoire totale (en octets) pour le stockage d'objets publics",Long.toString(info.ulTotalPublicMemory));			
							infos.put("Espace mmoire disponible (en octets) pour le stockage d'objets publics",Long.toString(info.ulFreePublicMemory));
							infos.put("Capacit mmoire totale (en octets) pour le stockage d'objets privs",Long.toString(info.ulTotalPrivateMemory));
							infos.put("Espace mmoire disponible (en octets) pour le stockage d'objets privs",Long.toString(info.ulFreePrivateMemory));
							infos.put("Numro de version matrielle de la carte",info.hardwareVersion.toString());
							infos.put("Numro de version firmware de la carte",info.firmwareVersion.toString());
							if(new String(info.utcTime).toString().trim().length() != 0)
								infos.put("Date de la carte",new String(info.utcTime));
							else
								infos.put("Date de la carte","indisponible");
							infos.put("La carte a son propre gnrateur de nombre alatoire?",(info.flags & PKCS11Constants.CKF_RNG)!=0?"Oui":"Non");			
							infos.put("La carte est-elle protge en criture?",(info.flags & PKCS11Constants.CKF_WRITE_PROTECTED)!=0?"Oui":"Non");
							infos.put("La carte ncessite-t-elle une authentification?",(info.flags & PKCS11Constants.CKF_LOGIN_REQUIRED)!=0?"Oui":"Non");
							infos.put("Le code porteur de l'utilisateur est-il initialis?",(info.flags & PKCS11Constants.CKF_USER_PIN_INITIALIZED)!=0?"Oui":"Non");
							infos.put("La sauvegarde russie de l'tat d'une opration cryptographique de session contient-elle toutes les cls ncessaires pour rtablir l'tat de la session?",(info.flags & PKCS11Constants.CKF_RESTORE_KEY_NOT_NEEDED)!=0?"Oui":"Non");
							infos.put("La carte possde-t-elle une horloge?",(info.flags & PKCS11Constants.CKF_CLOCK_ON_TOKEN)!=0?"Oui":"Non");
							infos.put("La carte a-t-elle un mode d'authentification protg par o l'utilisateur peut s'authentifier sans passer de code porteur au travers d'une bibliothque cryptographique?",(info.flags & PKCS11Constants.CKF_PROTECTED_AUTHENTICATION_PATH)!=0?"Oui":"Non");
							infos.put("La carte permet-elle l'excution d'oprations cryptographiques \"dual\" lors d'une mme session?",(info.flags & PKCS11Constants.CKF_DUAL_CRYPTO_OPERATIONS)!=0?"Oui":"Non");
							infos.put("La carte est-elle initialise?",(info.flags & PKCS11Constants.CKF_TOKEN_INITIALIZED)!=0?"Oui":"Non");
							infos.put("Un code porteur utilisateur incorrect a-t-il t saisi au moins une fois depuis la dernire authentification utilisateur russie?",(info.flags & PKCS11Constants.CKF_USER_PIN_COUNT_LOW)!=0?"Oui":"Non");
							infos.put("La prochaine saisie d'un code porteur utilisateur incorrect provoquera-t-elle le blocage du token?",(info.flags & PKCS11Constants.CKF_USER_PIN_FINAL_TRY)!=0?"Oui":"Non");
							infos.put("Le code porteur utilisateur est-il bloqu?",(info.flags & PKCS11Constants.CKF_USER_PIN_LOCKED)!=0?"Oui":"Non");
							infos.put("Le code porteur utilisateur doit-il tre chang?",(info.flags & PKCS11Constants.CKF_USER_PIN_TO_BE_CHANGED)!=0?"Oui":"Non");
							infos.put("Un code porteur Security Officer(SO) incorrect a-t-il t saisi au moins une fois depuis la dernire authentification SO russie?",(info.flags & PKCS11Constants.CKF_SO_PIN_COUNT_LOW)!=0?"Oui":"Non");
							infos.put("La prochaine saisie d'un code porteur SO incorrect provoquera-t-elle le blocage de la carte?",(info.flags & PKCS11Constants.CKF_SO_PIN_FINAL_TRY)!=0?"Oui":"Non");
							infos.put("Le code porteur SO est-il bloqu?",(info.flags & PKCS11Constants.CKF_SO_PIN_LOCKED)!=0?"Oui":"Non");
							infos.put("Le code porteur SO doit-il tre chang?",(info.flags & PKCS11Constants.CKF_SO_PIN_TO_BE_CHANGED)!=0?"Oui":"Non");
							
						} else {
							
							resultat.appendTraitement("(C_GetTokenInfo)");
							
							// Si les informations sont nulles on lve l'exception
							log.error("L'operation a retourne des informations nulles");
							throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_CARTE, "L'opration a retourn des informations nulles");
							
						}
					}
					
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
		
				return resultat;
				
			} else {
	
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_CARTE, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_CARTE, "Une erreur inattendue est survenue");
			
		}
	}

}
